/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.weapon;

import dev.xkmc.mob_weapon_api.registry.IWeaponStatusPredicate;
import dev.xkmc.mob_weapon_api.registry.WeaponRegistry;
import dev.xkmc.mob_weapon_api.registry.WeaponStatus;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemBowAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemCrossbowAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemHoldRangedAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemShooterHelper;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemSimpleRangedAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemTridentAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.IWeaponGoalFactory;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WeaponGoalsRegistry {
    private static final LinkedHashMap<ResourceLocation, WeaponGoalEntry> KNOWLEDGE = new LinkedHashMap();

    public static void register(ResourceLocation id, IWeaponStatusPredicate item, IWeaponGoalFactory<?> goal) {
        KNOWLEDGE.put(id, new WeaponGoalEntry(item, goal));
    }

    @Nullable
    public static WeaponSearchResult find(LivingEntity user, ItemStack weapon, @Nullable InteractionHand hand) {
        for (Map.Entry<ResourceLocation, WeaponGoalEntry> ent : KNOWLEDGE.entrySet()) {
            Optional status = ent.getValue().item().getProperties(user, weapon, hand);
            if (!status.isPresent()) continue;
            return new WeaponSearchResult(ent.getKey(), (WeaponStatus)status.get(), ent.getValue());
        }
        return null;
    }

    public static void init() {
        WeaponGoalsRegistry.register(ModularGolems.loc("throwable"), (golem, stack, hand) -> WeaponStatus.OFFENSIVE.of(GolemShooterHelper.isValidThrowableWeapon(golem, stack, hand)), (golem, melee) -> new GolemTridentAttackGoal(golem, 1.0, 20, 25.0f, melee));
        WeaponGoalsRegistry.register(ModularGolems.loc("bow"), (golem, stack, hand) -> WeaponRegistry.BOW.getProperties(stack), (golem, melee) -> new GolemBowAttackGoal(golem, melee, 1.0, 25.0));
        WeaponGoalsRegistry.register(ModularGolems.loc("crossbow"), (golem, stack, hand) -> WeaponRegistry.CROSSBOW.getProperties(stack), (golem, melee) -> new GolemCrossbowAttackGoal(golem, melee, 1.0, 25.0f));
        WeaponGoalsRegistry.register(ModularGolems.loc("instant"), (golem, stack, hand) -> WeaponRegistry.INSTANT.getProperties(stack), (golem, melee) -> new GolemSimpleRangedAttackGoal(golem, melee, 1.0));
        WeaponGoalsRegistry.register(ModularGolems.loc("hold"), (golem, stack, hand) -> WeaponRegistry.HOLD.getProperties(stack), (golem, melee) -> new GolemHoldRangedAttackGoal(golem, melee, 1.0));
    }

    public record WeaponGoalEntry(IWeaponStatusPredicate item, IWeaponGoalFactory<?> goal) {
    }

    public record WeaponSearchResult(ResourceLocation id, WeaponStatus status, WeaponGoalEntry entry) {
    }
}

